local NPC_TALK_RADIUS = 4
local sDesiredMercDist
local NO_PROFILE = 200

Facts = 
{ 
	FACT_SKYRIDER_CLOSE_TO_CHOPPER = 43,
	FACT_MARIA_ESCORTED_AT_LEATHER_SHOP = 117,
	FACT_JOEY_NEAR_MARTHA = 110,
	FACT_JOHN_ALIVE = 190,
	FACT_MARY_OR_JOHN_ARRIVED = 192,
	FACT_MARY_ALIVE = 187,
	FACT_FIRST_ROBOT_DESTROYED = 203,
    FACT_ROBOT_READY_SECOND_TIME = 205,
    FACT_SECOND_ROBOT_DESTROYED = 206,
	FACT_ILOSC_DNI_DO_KONCA_15 = 385,
	FACT_ILOSC_DNI_DO_KONCA_25 = 386,
	FACT_ILOSC_DNI_DO_KONCA_30 = 387,
	FACT_ILOSC_DNI_DO_KONCA_40 = 388,
	FACT_ILOSC_DNI_STOP = 389,
}

Attitude = 
{
	DEFENSIVE      = 0,
	BRAVESOLO      = 1,
	BRAVEAID       = 2,
	CUNNINGSOLO    = 3,
	CUNNINGAID     = 4,
	AGGRESSIVE     = 5,
	MAXATTITUDES   = 6,
	ATTACKSLAYONLY = 7,
}

Quests = 
{
	QUEST_DELIVER_LETTER = 0,
	QUEST_FOOD_ROUTE = 1,
	QUEST_KILL_TERRORISTS = 2,
	QUEST_KINGPIN_IDOL = 3,
	QUEST_KINGPIN_MONEY = 4,
	QUEST_RUNAWAY_JOEY = 5,
	QUEST_RESCUE_MARIA = 6,
	QUEST_CHITZENA_IDOL = 7,
	QUEST_HELD_IN_ALMA = 8,
	QUEST_INTERROGATION = 9,
	QUEST_ARMY_FARM = 10,
	QUEST_FIND_SCIENTIST = 11,
	QUEST_DELIVER_VIDEO_CAMERA = 12,
	QUEST_BLOODCATS = 13,
	QUEST_FIND_HERMIT = 14,
	QUEST_CREATURES = 15,
	QUEST_CHOPPER_PILOT = 16,
	QUEST_ESCORT_SKYRIDER = 17,
	QUEST_FREE_DYNAMO = 18,
	QUEST_ESCORT_TOURISTS = 19,
	QUEST_FREE_CHILDREN = 20,
	QUEST_LEATHER_SHOP_DREAM = 21,
	QUEST_KILL_DEIDRANNA = 25,
	
	-- Legion 2
	QUEST_WARTOWNIA = 26,
	QUEST_SIERZANT = 27,
}

Profil = 
{	
	MIGUEL = 57,
	CARLOS = 58,
	IRA = 59, 
	DIMITRI = 60,	
	SLAY = 64,
	DYNAMO = 66,
	SHANK = 67,
	CARMEN = 78,
	MARIA = 88,
	ANGEL = 89,
	JOEY = 90,	
	SKYRIDER = 97,
	JOHN = 118,	
	MARY = 119,
	JIM = 140,
	JACK = 141,
	OLAF = 142,
	RAY = 143,
	OLGA = 144,
	TYRONE = 145,
	MADLAB = 146,
}

What = 
{
	MERC_TYPE__PLAYER_CHARACTER = 0,
	MERC_TYPE__AIM_MERC = 1,
	MERC_TYPE__MERC = 2,
	MERC_TYPE__NPC = 3,
	MERC_TYPE__EPC = 4,
	MERC_TYPE__NPC_WITH_UNEXTENDABLE_CONTRACT = 5,
	MERC_TYPE__VEHICLE = 6,
}

Team = {
	OUR_TEAM = 0,
	ENEMY_TEAM = 1,
	CREATURE_TEAM = 2,
	MILITIA_TEAM = 3,	
	CIV_TEAM = 4,	
	PLAYER_PLAN	= 5,
	LAN_TEAM_ONE = 6,
	LAN_TEAM_TWO = 7,
	LAN_TEAM_THREE = 8,
	LAN_TEAM_FOUR = 9,
}

pQuest = 
{
	QUESTNOTSTARTED = 0,
	QUESTINPROGRESS = 1,
	QUESTDONE = 2,
}

Group = 
{
	NON_CIV_GROUP = 0,
	REBEL_CIV_GROUP = 1,
	KINGPIN_CIV_GROUP = 2,
	SANMONA_ARMS_GROUP = 3,
	ANGELS_GROUP = 4,
	BEGGARS_CIV_GROUP = 5,
	TOURISTS_CIV_GROUP = 6,
	ALMA_MILITARY_CIV_GROUP = 7,
	DOCTORS_CIV_GROUP = 8,
	COUPLE1_CIV_GROUP = 9,
	HICKS_CIV_GROUP = 10,
	WARDEN_CIV_GROUP = 11,
	JUNKYARD_CIV_GROUP = 12,
	FACTORY_KIDS_GROUP = 13,
	QUEENS_CIV_GROUP = 14,
	
	UNNAMED_CIV_GROUP_230 =230,
	UNNAMED_CIV_GROUP_48 = 48,
	
	POLICJA_CIV_GROUP_86 = 86,
	ROBOTY = 75,
}

Status = 
{
	CIV_GROUP_NEUTRAL = 0,
	CIV_GROUP_WILL_EVENTUALLY_BECOME_HOSTILE = 1,
	CIV_GROUP_WILL_BECOME_HOSTILE = 2,
	CIV_GROUP_HOSTILE = 3,
}

SectorY = 
{
	MAP_ROW_A = 1,
	MAP_ROW_B = 2,
	MAP_ROW_C = 3,
	MAP_ROW_D = 4,
	MAP_ROW_E = 5,
	MAP_ROW_F = 6,
	MAP_ROW_G = 7,
	MAP_ROW_H = 8,
	MAP_ROW_I = 9,
	MAP_ROW_J = 10,
	MAP_ROW_K = 11,
	MAP_ROW_L = 12,
	MAP_ROW_M = 13,
	MAP_ROW_N = 14,
	MAP_ROW_O = 15,
	MAP_ROW_P = 16,
}

SoldierBodyTypes =
{
	REGMALE = 0,
	BIGMALE = 1,
	STOCKYMALE = 2,
	REGFEMALE = 3,
	ADULTFEMALEMONSTER = 4,
	AM_MONSTER = 5,
	YAF_MONSTER = 6,
	YAM_MONSTER = 7,
	LARVAE_MONSTER = 8,
	INFANT_MONSTER = 9,
	QUEENMONSTER = 10,
	FATCIV  = 11,
	MANCIV = 12,
	MINICIV = 13,
	DRESSCIV = 14,
	HATKIDCIV = 15,
	KIDCIV = 16,
	CRIPPLECIV = 17,

	COW = 18,
	CROW = 19,
	BLOODCAT = 20,

	ROBOTNOWEAPON = 21,

	HUMVEE = 22,
	TANK_NW = 23,
	TANK_NE = 24,
	ELDORADO = 25,
	ICECREAMTRUCK = 26,
	JEEP = 27,
} 

GridNoNew = {
			11892,
			13814,
			13496,
			13650,
			13173,
			14770,
}

GridNoNewC7 = {
			12075,
			10777,
			8857,
			8552,
			11754,
			11611,
}

local HEARD_3_TURNS_AGO	= -4
local HEARD_2_TURNS_AGO	= -3
local HEARD_LAST_TURN	=  -2
local HEARD_THIS_TURN	= -1
local NOT_HEARD_OR_SEEN	= 0
local SEEN_CURRENTLY	= 1
local SEEN_THIS_TURN	= 2
local SEEN_LAST_TURN	= 3
local SEEN_2_TURNS_AGO	=4
local SEEN_3_TURNS_AGO = 5

local LAST_TEAM = Team.LAN_TEAM_FOUR

local iLoop
local aimLoop
local Slot = 0

local Spike_Gridno = 33445 -- BigMaps (G12)
local Oswald_Gridno = 18628
local Prof150_Gridn = 7618
local Prof115_Gridn = 9373

local G12_Gridno_01 = 27687 -- BigMaps, Garaż (G12) 

local K3_Gridno_01 = 15966
local K3_Gridno_02 = 3909

local M3_Gridno_01 = 5185
local M3_Gridno_02 = 17716
local M3_Gridno_03 = 11505

local L3_Gridno_01 = 34047
local L3_Gridno_02 = 35360
local L3_Gridno_03 = 8448
local L3_Gridno_04 = 7135

local K6_Gridno_01 = 12705

local Dialogi = true

local function TestGame(profid)

			-- test game
			if ( CheckGlobalBool(33) == true and gWorldSectorX == 6 and gWorldSectorY == SectorY.MAP_ROW_K and gWorldSectorZ == 0 )then 
				if ( CheckGlobalBool(999) == false ) then
					CreateItem (4514, 100,GetNPCGridNo(profid),0) -- Plan
					CreateItem (4515, 100,GetNPCGridNo(profid),0) -- Remote Control
					CreateItem (4522, 100,GetNPCGridNo(profid),0) -- Krzyz
					CreateItem (4524, 100,GetNPCGridNo(profid),0) -- Bear
					CreateItem (4513, 100,GetNPCGridNo(profid),0) -- Medical instruments
					CreateItem (4503, 100,GetNPCGridNo(profid),0) -- Photo
					CreateItem (4525, 100,GetNPCGridNo(profid),0) -- Head
					CreateItem (4529, 100,GetNPCGridNo(profid),0) -- cd
					SetGlobalTrue (999)
				end
			end
end

function HandleAtNewGridNo( ProfileId )

	if ( CheckFact(481,0) == true and CheckGlobalBool(432) == true and CheckGlobalBool(431) == true and CheckGlobalBool(438) == false and gWorldSectorX == 8 and gWorldSectorY == SectorY.MAP_ROW_D and gWorldSectorZ == 0 ) then	
		ApplyMapChangesToMapTempFile(true)
		AddExitGridToWorld (8, SectorY.MAP_ROW_D, 1, 16900,16730)
		WorldLevelDataMapElementRevealed(16730)			
		ApplyMapChangesToMapTempFile(false)		
		SetRender()
		SetGlobalTrue (438)
	end
	
	if ( CheckFact(483,0) == true and CheckGlobalBool(437) == false and CheckMercIsDead(107) == true and gWorldSectorX == 7 and gWorldSectorY == SectorY.MAP_ROW_D and gWorldSectorZ == 0 ) then	
		ApplyMapChangesToMapTempFile(true)
		AddExitGridToWorld (7, SectorY.MAP_ROW_D, 1, 8870,9825)
		WorldLevelDataMapElementRevealed(9825)			
		ApplyMapChangesToMapTempFile(false)		
		SetRender()
		SetGlobalTrue (437)
	end
	
	-- Alfred zginął w jakiejś innym zdarzeniu.
		if ( CheckMercIsDead(60) == true and CheckGlobalBool(803) == false ) then
			
			if ( Legion2_GameEndDay == 0 ) then
				SetFactTrue( Facts.FACT_ILOSC_DNI_DO_KONCA_15 )
			elseif ( Legion2_GameEndDay == 1 ) then
				SetFactTrue( Facts.FACT_ILOSC_DNI_DO_KONCA_25 )
			elseif ( Legion2_GameEndDay == 2 ) then	
				SetFactTrue( Facts.FACT_ILOSC_DNI_DO_KONCA_30 )
			elseif ( Legion2_GameEndDay == 3 ) then
				SetFactTrue( Facts.FACT_ILOSC_DNI_DO_KONCA_40 )
			elseif ( Legion2_GameEndDay == 4 ) then
				SetFactTrue( Facts.FACT_ILOSC_DNI_DO_KONCA_200 )
			end
			
			SetFactTrue( 389 )
			
			if ( CheckQuest (33) == pQuest.QUESTINPROGRESS ) then
				EndQuest(33,gWorldSectorX,gWorldSectorY) 
			end
		
			ChangeNpcToDifferentSector( 60, 0, 0, 0 )
				
			if ( Legion2_BriefingRoom == true ) then
				SetStartMission (0) -- set mission 1	
			end
			
			SetGlobalTrue (803)
	
		end
	
 -- powiązane ze skryptem 380.lua
 if ( CheckGlobalBool(108) == false and GetNPCGridNo(137) == Oswald_Gridno and GetgubFact (434) == true and CheckMercIsDead (137) == false and gWorldSectorX == 1 and gWorldSectorY == SectorY.MAP_ROW_L and gWorldSectorZ == 0 ) then
      DestroyedTimeCursor()
	  SetGlobalTrue (108)
  end
  
 -- powiązane ze skryptem 384.lua
 if ( CheckGlobalBool(109) == false and GetNPCGridNo(93) == Spike_Gridno and GetgubFact (384) == false and CheckMercIsDead (93) == false and gWorldSectorX == 12 and gWorldSectorY == SectorY.MAP_ROW_G and gWorldSectorZ == 0 ) then
      DestroyedTimeCursor()
	  SetProfileStrategicInsertionData(93,Spike_Gridno)
	  SetGlobalTrue (109)
  end
  
 -- powiązane ze skryptem 354.lua
 if ( CheckGlobalBool(121) == false and GetNPCGridNo(150) == Prof150_Gridn and CheckMercIsDead (150) == false and gWorldSectorX == 10 and gWorldSectorY == SectorY.MAP_ROW_O and gWorldSectorZ == 0 ) then
      DestroyedTimeCursor()
	  SetProfileStrategicInsertionData(150,Prof150_Gridn)
	  SetGlobalTrue (121)
  end
  
	if ( GetgubFact (382) == true and CheckGlobalBool(421) == false and gWorldSectorX == 8 and gWorldSectorY == SectorY.MAP_ROW_F and gWorldSectorZ == 0 ) then
	
		-- Bobi Gang F8
		for op = 1,6 do
			NewCiv = { }
			NewCiv.ubProfile = NO_PROFILE
			NewCiv.bTeam = Team.CIV_TEAM
			NewCiv.bBodyType = SoldierBodyTypes.BIGMALE
			NewCiv.sInsertionGridNo = GridNoNew[op]
			NewCiv.ubCivilianGroup = 85
			NewCiv.RandomizeNewSoldierStats = true
			NewCiv.VESTPOS = 164
			NewCiv.LEGPOS = 170
			NewCiv.HANDPOS = 16
			NewCiv.BIGPOCK1POS = 214
			NewCiv.BIGPOCK2POS = 131
			Legion2_CreateTacticalCivType(NewCiv)
		end
		SetGlobalTrue (421)
	end
	
	if ( CheckFact(470,0) == true and CheckFact(455,0) == true and CheckGlobalBool(422) == false and gWorldSectorX == 7 and gWorldSectorY == SectorY.MAP_ROW_C and gWorldSectorZ == 0 ) then
	
		-- Chris C7		
		for op1 = 1,6 do
			NewCiv = { }
			NewCiv.ubProfile = NO_PROFILE
			NewCiv.bTeam = Team.CIV_TEAM
			
			los = math.random(1, 100)
			
			if (los > 50 ) then
			NewCiv.bBodyType = SoldierBodyTypes.BIGMALE
			else
			NewCiv.bBodyType = SoldierBodyTypes.REGMALE
			end
			
			NewCiv.sInsertionGridNo = GridNoNewC7[op1]
			NewCiv.ubCivilianGroup = 230
			NewCiv.RandomizeNewSoldierStats = true
			NewCiv.VESTPOS = 167
			NewCiv.LEGPOS = 170
			NewCiv.HANDPOS = 12
			NewCiv.HELMETPOS = 177
			NewCiv.BIGPOCK1POS = 213
			NewCiv.BIGPOCK2POS = 211
			NewCiv.BIGPOCK3POS = 134
			NewCiv.BIGPOCK4POS = 133
			Legion2_CreateTacticalCivType(NewCiv)
		end
		SetGlobalTrue (422)
	end

	TeamSoldier = FindSoldierTeam (ProfileId)
	
  if ( TeamSoldier == Team.OUR_TEAM ) then -- Team
  
     if ( WhatKindOfMercAmI (ProfileId) == What.MERC_TYPE__NPC or WhatKindOfMercAmI (ProfileId) == What.MERC_TYPE__AIM_MERC or WhatKindOfMercAmI (ProfileId) == What.MERC_TYPE__PLAYER_CHARACTER and Dialogi == true ) then
	 
		-- Wartownia
		if ( WhatKindOfMercAmI (ProfileId) == What.MERC_TYPE__PLAYER_CHARACTER and CheckNPCSectorBool( 60,8,11,0 ) == true and CheckMercIsDead (ProfileId) == false and CheckGlobalBool(681) == false and CheckGlobalBool(99) == true and gWorldSectorX == 8 and gWorldSectorY == SectorY.MAP_ROW_K and gWorldSectorZ == 0 ) then
			SetGlobalTrue (666)
			SetGlobalTrue (665) -- no sample
			if ( CheckGlobalBool(666) == true ) then
				Legion2_SetDialogue (17,ProfileId)
			end
			SetGlobalTrue (681)
		end
		
		-- Obóz (K6)
		if ( WhatKindOfMercAmI (ProfileId) == What.MERC_TYPE__PLAYER_CHARACTER and CheckMercIsDead (ProfileId) == false and CheckGlobalBool(682) == false and ( CheckGlobalBool(99) == true or CheckGlobalBool(99) == false ) and gWorldSectorX == 6 and gWorldSectorY == SectorY.MAP_ROW_K and gWorldSectorZ == 0 ) then
			SetGlobalTrue (666)
			SetGlobalTrue (665) -- no sample
			if ( CheckGlobalBool(666) == true ) then
				Legion2_SetDialogue (9,ProfileId)
			end
			SetGlobalTrue (682)
		end
		
		--[[
		-- Obóz pusty (K6)
		if ( WhatKindOfMercAmI (ProfileId) == What.MERC_TYPE__PLAYER_CHARACTER and CheckQuest (33) == pQuest.QUESTINPROGRESS and CheckMercIsDead (ProfileId) == false and PythSpacesAway( ProfileId,K6_Gridno_01 ) < 5 and CheckGlobalBool(683) == false and ( CheckNPCSectorBool( 60,12,7,0 ) == true or CheckNPCSectorBool( 60,12,6,0 ) == true or CheckNPCSectorBool( 60,8,11,0 ) == true ) ) then
			SetGlobalTrue (666)
			SetGlobalTrue (665) -- no sample
			Legion2_SetSoundProfile(ProfileId,false)
			if ( CheckGlobalBool(666) == true ) then
				Legion2_SetDialogue (10,ProfileId)
			end
			SetGlobalTrue (683)
		end
		]]
		
		-- H13 (Pacos)
		if ( WhatKindOfMercAmI (ProfileId) == What.MERC_TYPE__PLAYER_CHARACTER and CheckQuest (1) == pQuest.QUESTINPROGRESS and CheckMercIsDead (ProfileId) == false and CheckGlobalBool(684) == false and gWorldSectorX == 13 and gWorldSectorY == SectorY.MAP_ROW_H and gWorldSectorZ == 0 and CheckNPCSectorBool( 114,13,8,0 ) == true ) then
			SetGlobalTrue (666)
			SetGlobalTrue (665) -- no sample
			if ( CheckGlobalBool(666) == true ) then
				Legion2_SetDialogue (25,ProfileId)
			end
			SetGlobalTrue (684)
		end
		
		-- I8 (Rozu)
		if ( WhatKindOfMercAmI (ProfileId) == What.MERC_TYPE__PLAYER_CHARACTER and CheckMercIsDead (ProfileId) == false and CheckGlobalBool(685) == false and gWorldSectorX == 8 and gWorldSectorY == SectorY.MAP_ROW_I and gWorldSectorZ == 0 and CheckNPCSectorBool( 111,8,9,0 ) == true ) then
			SetGlobalTrue (666)
			SetGlobalTrue (665) -- no sample
			if ( CheckGlobalBool(666) == true ) then
				Legion2_SetDialogue (18,ProfileId)
			end
			SetGlobalTrue (685)
		end
		
		-- L3 (Posterunek)
		if ( WhatKindOfMercAmI (ProfileId) == What.MERC_TYPE__PLAYER_CHARACTER and CheckMercIsDead (ProfileId) == false and CheckMercIsDead (80) == false and CheckGlobalBool(686) == false and gWorldSectorX == 3 and gWorldSectorY == SectorY.MAP_ROW_L and gWorldSectorZ == 0 ) then
			SetGlobalTrue (666)
			SetGlobalTrue (665) -- no sample
			if ( CheckGlobalBool(666) == true ) then
				Legion2_SetDialogue (11,ProfileId)
			end
			SetGlobalTrue (686)
		end
		
		-- M3 (Ukryta baza Tygrysa)
		if ( WhatKindOfMercAmI (ProfileId) == What.MERC_TYPE__PLAYER_CHARACTER and CheckMercIsDead (ProfileId) == false and CheckGlobalBool(687) == false and CheckGlobalBool(801) == true and gWorldSectorX == 3 and gWorldSectorY == SectorY.MAP_ROW_M and gWorldSectorZ == 0 ) then
			SetGlobalTrue (666)
			SetGlobalTrue (665) -- no sample
			if ( CheckGlobalBool(666) == true ) then
				Legion2_SetDialogue (23,ProfileId)
			end
			SetGlobalTrue (687)
		end
		
		-- J9 (Ukryta baza)
		if ( WhatKindOfMercAmI (ProfileId) == What.MERC_TYPE__PLAYER_CHARACTER and CheckMercIsDead (ProfileId) == false and CheckGlobalBool(688) == false and CheckGlobalBool(800) == true and gWorldSectorX == 9 and gWorldSectorY == SectorY.MAP_ROW_J and gWorldSectorZ == 0 ) then
			SetGlobalTrue (666)
			SetGlobalTrue (665) -- no sample
			if ( CheckGlobalBool(666) == true ) then
				Legion2_SetDialogue (22,ProfileId)
			end
			SetGlobalTrue (688)
		end

	 end
	 
     if ( WhatKindOfMercAmI (ProfileId) == What.MERC_TYPE__NPC or WhatKindOfMercAmI (ProfileId) == What.MERC_TYPE__AIM_MERC or WhatKindOfMercAmI (ProfileId) == What.MERC_TYPE__PLAYER_CHARACTER ) then

		if ( ProfileId == 111 and CheckGlobalBool(667) == false and gWorldSectorX == 12 and gWorldSectorY == SectorY.MAP_ROW_G and gWorldSectorZ == 0 ) then
			SetGlobalTrue (666)
			if ( CheckGlobalBool(666) == true ) then
				Legion2_SetDialogue (0,111)
			end
			SetGlobalTrue (667)
		end
		
		if ( ProfileId == 111 and CheckGlobalBool(668) == false and gWorldSectorX == 12 and gWorldSectorY == SectorY.MAP_ROW_F and gWorldSectorZ == 0 ) then
			SetGlobalTrue (666)
			if ( CheckGlobalBool(666) == true ) then
				Legion2_SetDialogue (1,111)
			end
			SetGlobalTrue (668)
		end
		
		if ( ProfileId == 111 and CheckGlobalBool(669) == false and gWorldSectorX == 11 and gWorldSectorY == SectorY.MAP_ROW_B and gWorldSectorZ == 0 ) then
			SetGlobalTrue (666)
			if ( CheckGlobalBool(666) == true ) then
				Legion2_SetDialogue (2,111)
			end
			SetGlobalTrue (669)
		end
		
		if ( ProfileId == 111 and CheckGlobalBool(670) == false and gWorldSectorX == 7 and gWorldSectorY == SectorY.MAP_ROW_C and gWorldSectorZ == 0 ) then
			SetGlobalTrue (666)
			if ( CheckGlobalBool(666) == true ) then
				Legion2_SetDialogue (3,111)
			end
			SetGlobalTrue (670)
		end
		
		if ( ProfileId == 111 and CheckGlobalBool(671) == false and gWorldSectorX == 8 and gWorldSectorY == SectorY.MAP_ROW_D and gWorldSectorZ == 0 ) then
			SetGlobalTrue (666)
			if ( CheckGlobalBool(666) == true ) then
				Legion2_SetDialogue (4,111)
			end
			SetGlobalTrue (671)
		end
		
		if ( ProfileId == 111 and CheckGlobalBool(672) == false and gWorldSectorX == 7 and gWorldSectorY == SectorY.MAP_ROW_D and gWorldSectorZ == 0 ) then
			SetGlobalTrue (666)
			if ( CheckGlobalBool(666) == true ) then
				Legion2_SetDialogue (5,111)
			end
			SetGlobalTrue (672)
		end
		
		if ( ProfileId == 111 and CheckGlobalBool(673) == false and gWorldSectorX == 8 and gWorldSectorY == SectorY.MAP_ROW_C and gWorldSectorZ == 0 ) then
			SetGlobalTrue (666)
			if ( CheckGlobalBool(666) == true ) then
				Legion2_SetDialogue (6,111)
			end
			SetGlobalTrue (673)
		end
		
		if ( ProfileId == 111 and CheckGlobalBool(674) == false and gWorldSectorX == 10 and gWorldSectorY == SectorY.MAP_ROW_O and gWorldSectorZ == 0 ) then
			SetGlobalTrue (666)
			if ( CheckGlobalBool(666) == true ) then
				Legion2_SetDialogue (7,111)
			end
			SetGlobalTrue (674)
		end
		
		if ( ProfileId == 111 and CheckGlobalBool(675) == false and gWorldSectorX == 3 and gWorldSectorY == SectorY.MAP_ROW_L and gWorldSectorZ == 0 ) then
			SetGlobalTrue (666)
			if ( CheckGlobalBool(666) == true ) then
				Legion2_SetDialogue (11,111)
			end
			SetGlobalTrue (675)
		end
		
		if ( ProfileId == 111 and CheckGlobalBool(676) == false and gWorldSectorX == 3 and gWorldSectorY == SectorY.MAP_ROW_C and gWorldSectorZ == 0 ) then
			SetGlobalTrue (666)
			if ( CheckGlobalBool(666) == true ) then
				Legion2_SetDialogue (13,111)
			end
			SetGlobalTrue (676)
		end
		
		if ( ProfileId == 111 and CheckGlobalBool(677) == false and gWorldSectorX == 1 and gWorldSectorY == SectorY.MAP_ROW_L and gWorldSectorZ == 0 ) then
			SetGlobalTrue (666)
			if ( CheckGlobalBool(666) == true ) then
				Legion2_SetDialogue (19,111)
			end
			SetGlobalTrue (677)
		end
		
		-- J9 (Ukryta baza)
		if ( ProfileId == 111 and CheckGlobalBool(678) == false and CheckGlobalBool(800) == true and gWorldSectorX == 9 and gWorldSectorY == SectorY.MAP_ROW_J and gWorldSectorZ == 0 ) then
			SetGlobalTrue (666)
			if ( CheckGlobalBool(666) == true ) then
				Legion2_SetDialogue (22,111)
			end
			SetGlobalTrue (678)
		end
		
		-- M3 (Ukryta baza Tygrysa)
		if ( ProfileId == 111 and CheckGlobalBool(679) == false and CheckGlobalBool(801) == true and gWorldSectorX == 3 and gWorldSectorY == SectorY.MAP_ROW_M and gWorldSectorZ == 0 ) then
			SetGlobalTrue (666)
			if ( CheckGlobalBool(666) == true ) then
				Legion2_SetDialogue (23,111)
			end
			SetGlobalTrue (679)
		end
		
		-- A15 (Kopalnia)
		if ( ProfileId == 111 and CheckGlobalBool(680) == false and CheckGlobalBool(802) == true and gWorldSectorX == 15 and gWorldSectorY == SectorY.MAP_ROW_A and gWorldSectorZ == 0 ) then
			SetGlobalTrue (666)
			if ( CheckGlobalBool(666) == true ) then
				Legion2_SetDialogue (24,111)
			end
			SetGlobalTrue (680)
		end
	 
	 end
	 
	 
    if ( WhatKindOfMercAmI (ProfileId) == What.MERC_TYPE__AIM_MERC or WhatKindOfMercAmI (ProfileId) == MERC_TYPE__PLAYER_CHARACTER ) then
	
		-- test game
		TestGame(ProfileId)
	
		-- Alfred w K8
		if ( CheckGlobalBool(99) == true and CheckGlobalBool(34) == false and gWorldSectorX == 8 and gWorldSectorY == SectorY.MAP_ROW_K and gWorldSectorZ == 0 ) then
			SetGlobalTrue(34)
			AddCreateItemToPool( 4524, 100, 32857, 0, 0, 0) -- bear
			AddCreateItemToPool( 4503, 100, 32857, 0, 0, 0) -- photo
		end
		
		-- Wartownia zdobyta
		if ( CheckGlobalBool(106) == false and Legion2_SectorEnemyControlled ( CALCULATE_STRATEGIC_INDEX( 8,SectorY.MAP_ROW_K ) ) == false ) then
			AddHistoryToPlayersLog( 78 + 3, 0, GetWorldTotalMin(), gWorldSectorX, gWorldSectorY )
			SetGlobalTrue(106)	
		end
		
		-- Rainman
		if ( CheckGlobalBool(48) == true and Legion2_SectorEnemyControlled ( CALCULATE_STRATEGIC_INDEX( 8,4 ) ) == true and CheckGlobalBool(41) == false and gWorldSectorX == 8 and gWorldSectorY == SectorY.MAP_ROW_D and gWorldSectorZ == 0 )then 	
			for iLoop = GetTacticalStatusFirstID(Team.CIV_TEAM),GetTacticalStatusLastID(Team.CIV_TEAM) do
				if ( CheckMercPtrsInSector (iLoop) == true and CheckMercPtrsInActive(iLoop) == true and CheckMercPtrsInCivilianGroup (iLoop) == 104 ) then
					for aimLoop=GetTacticalStatusFirstID(Team.OUR_TEAM),GetTacticalStatusLastID(Team.OUR_TEAM) do
						if ( CheckMercPtrsID1SeenID2(iLoop,aimLoop) == SEEN_CURRENTLY ) then
						TriggerNPCRecordImmediately (69 , 8)
						SetGlobalFalse(41)
						end
					end	
				end	
			end
	
		end
		
		if ( CheckMercIsDead(66) == false and CheckMercIsDead(93) == false and 
			 GetgubFact (406) == false and 
			 NPCInRoomRange( ProfileId,4, 7) == true and
			 CheckNPCWithin( ProfileId, 66, 10 ) == true and 
			 CheckNPCSectorBool( 66,12,SectorY.MAP_ROW_G,0 ) == true and 
			 CheckNPCSectorBool( 93,12,SectorY.MAP_ROW_G,0 ) == true and 
			 gWorldSectorX == 12 and gWorldSectorY == SectorY.MAP_ROW_G and gWorldSectorZ == 0 ) then
			gubFact (406, true )
			TriggerNPCRecord( 93, 16 )				
		end	
		
		if ( CheckGlobalBool(48) == true and CheckMercIsDead(69) == true and CheckGlobalBool(40) == false and gWorldSectorX == 8 and gWorldSectorY == SectorY.MAP_ROW_D and gWorldSectorZ == 0 )then 	
			EnvEndRainStorm()
			SetGlobalTrue (40)
		end
		
		
		-- sektor M3_b1
		if ( gWorldSectorX == 3 and gWorldSectorY == SectorY.MAP_ROW_M and gWorldSectorZ == 1 ) then 
			for iLoop = GetTacticalStatusFirstID(Team.CIV_TEAM),GetTacticalStatusLastID(Team.CIV_TEAM) do
				if ( CheckMercPtrsInSector (iLoop) == true and CheckMercPtrsInActive(iLoop) == true and CheckMercPtrsInCivilianGroup (iLoop) == 108 ) then
					for aimLoop=GetTacticalStatusFirstID(Team.OUR_TEAM),GetTacticalStatusLastID(Team.OUR_TEAM) do
						if ( CheckMercPtrsID1SeenID2(iLoop,aimLoop) == SEEN_CURRENTLY ) then
						MakeMercPtrsHostile( iLoop )
						end
					end	
				end	
			end
 
		if ( CheckCombatMode == false ) then
			EnterTeamCombatMode(Team.CIV_TEAM)
		end	
	
		end
		
		-- C3
		if ( CheckGlobalBool(107) == false and gWorldSectorX == 3 and gWorldSectorY == SectorY.MAP_ROW_C and gWorldSectorZ == 0 )then 
		Legion2_SetTacticalStatusGroupAttack(SECTOR ( gWorldSectorX, gWorldSectorY ) ,58,Status.CIV_GROUP_HOSTILE)
		SetGlobalTrue (107)
			for iLoop = GetTacticalStatusFirstID(Team.CIV_TEAM),GetTacticalStatusLastID(Team.CIV_TEAM) do
				if ( CheckMercPtrsInSector (iLoop) == true and CheckMercPtrsInActive(iLoop) == true and CheckMercPtrsInCivilianGroup (iLoop) == 58 ) then
					for aimLoop=GetTacticalStatusFirstID(Team.OUR_TEAM),GetTacticalStatusLastID(Team.OUR_TEAM) do
						--if ( CheckMercPtrsID1SeenID2(iLoop,aimLoop) == SEEN_CURRENTLY ) then
						MakeMercPtrsHostile( iLoop )
						--end
					end	
				end	
			end
 
		if ( CheckCombatMode == false ) then
			EnterTeamCombatMode(Team.CIV_TEAM)
		end	
	
		end
		
		-- B4
		if ( CheckGlobalBool(52) == false and gWorldSectorX == 4 and gWorldSectorY == SectorY.MAP_ROW_B and gWorldSectorZ == 0 )then 
		
			for iLoop = GetTacticalStatusFirstID(Team.CIV_TEAM),GetTacticalStatusLastID(Team.CIV_TEAM) do
				if ( CheckMercPtrsInSector (iLoop) == true and CheckMercPtrsInActive(iLoop) == true and CheckMercPtrsInCivilianGroup (iLoop) == 231 ) then
						if ( ( NPCInRoom( ProfileId,21 ) == true or NPCInRoom(ProfileId,10 ) == true ) and CheckMercPtrsID1SeenID2(iLoop,GetPlayerMercID ( ProfileId )) == SEEN_CURRENTLY ) then
						MakeMercPtrsHostile( iLoop )
						SetGlobalTrue (52)
						Legion2_SetTacticalStatusGroupAttack(SECTOR (4,SectorY.MAP_ROW_B) ,231,Status.CIV_GROUP_HOSTILE)
					end	
				end	
			end
 
		if ( CheckCombatMode == false ) then
			EnterTeamCombatMode(Team.CIV_TEAM)
		end	
	
		end
		
		-- G5-b1 mutant
		if ( CheckGlobalBool(45) == false and gWorldSectorX == 5 and gWorldSectorY == SectorY.MAP_ROW_G and gWorldSectorZ == 1 )then 
		Legion2_SetTacticalStatusGroupAttack(SECTOR (5,SectorY.MAP_ROW_G) ,22,Status.CIV_GROUP_HOSTILE)
		SetGlobalTrue (45)
			for iLoop = GetTacticalStatusFirstID(Team.CIV_TEAM),GetTacticalStatusLastID(Team.CIV_TEAM) do
				if ( CheckMercPtrsInSector (iLoop) == true and CheckMercPtrsInActive(iLoop) == true and CheckMercPtrsInCivilianGroup (iLoop) == 22 ) then
					for aimLoop=GetTacticalStatusFirstID(Team.OUR_TEAM),GetTacticalStatusLastID(Team.OUR_TEAM) do
						--if ( CheckMercPtrsID1SeenID2(iLoop,aimLoop) == SEEN_CURRENTLY ) then
						MakeMercPtrsHostile( iLoop )
						--end
					end	
				end	
			end
 
		if ( CheckCombatMode == false ) then
			EnterTeamCombatMode(Team.CIV_TEAM)
		end	
	
		end
		
		-- G5-b1 roboty
		if ( CheckGlobalBool(46) == false and gWorldSectorX == 5 and gWorldSectorY == SectorY.MAP_ROW_G and gWorldSectorZ == 1 )then 
		Legion2_SetTacticalStatusGroupAttack(SECTOR (5,SectorY.MAP_ROW_G) ,75,Status.CIV_GROUP_HOSTILE)
		SetGlobalTrue (46)
			for iLoop = GetTacticalStatusFirstID(Team.CIV_TEAM),GetTacticalStatusLastID(Team.CIV_TEAM) do
				if ( CheckMercPtrsInSector (iLoop) == true and CheckMercPtrsInActive(iLoop) == true and CheckMercPtrsInCivilianGroup (iLoop) == 75 ) then
					for aimLoop=GetTacticalStatusFirstID(Team.OUR_TEAM),GetTacticalStatusLastID(Team.OUR_TEAM) do
						--if ( CheckMercPtrsID1SeenID2(iLoop,aimLoop) == SEEN_CURRENTLY ) then
						MakeMercPtrsHostile( iLoop )
						--end
					end	
				end	
			end
 
		if ( CheckCombatMode == false ) then
			EnterTeamCombatMode(Team.CIV_TEAM)
		end	
	
		end
		
		-- Żołnierz N10
		if ( NPCInRoom( ProfileId,73 ) == true and gWorldSectorX == 10 and gWorldSectorY == SectorY.MAP_ROW_N and gWorldSectorZ == 0 )then 
		Legion2_SetTacticalStatusGroupAttack(SECTOR (10,SectorY.MAP_ROW_N) ,57,Status.CIV_GROUP_HOSTILE)
		
			for iLoop = GetTacticalStatusFirstID(Team.CIV_TEAM),GetTacticalStatusLastID(Team.CIV_TEAM) do
				if ( CheckMercPtrsInSector (iLoop) == true and CheckMercPtrsInActive(iLoop) == true and CheckMercPtrsInCivilianGroup (iLoop) == 57 ) then
					for aimLoop=GetTacticalStatusFirstID(Team.OUR_TEAM),GetTacticalStatusLastID(Team.OUR_TEAM) do
						if ( CheckMercPtrsID1SeenID2(iLoop,aimLoop) == SEEN_CURRENTLY ) then
						MakeMercPtrsHostile( iLoop )
						end
					end	
				end	
			end
 
		if ( CheckCombatMode == false ) then
			EnterTeamCombatMode(Team.CIV_TEAM)
		end	
	
		end
		
		-- Ochrona
		if ( NPCInRoom( ProfileId,73 ) == true and gWorldSectorX == 7 and gWorldSectorY == SectorY.MAP_ROW_D and gWorldSectorZ == 0 )then 
		Legion2_SetTacticalStatusGroupAttack(SECTOR (7,SectorY.MAP_ROW_D) ,87,Status.CIV_GROUP_HOSTILE)
		
			for iLoop = GetTacticalStatusFirstID(Team.CIV_TEAM),GetTacticalStatusLastID(Team.CIV_TEAM) do
				if ( CheckMercPtrsInSector (iLoop) == true and CheckMercPtrsInActive(iLoop) == true and CheckMercPtrsInCivilianGroup (iLoop) == 87 ) then
					for aimLoop=GetTacticalStatusFirstID(Team.OUR_TEAM),GetTacticalStatusLastID(Team.OUR_TEAM) do
						if ( CheckMercPtrsID1SeenID2(iLoop,aimLoop) == SEEN_CURRENTLY ) then
						MakeMercPtrsHostile( iLoop )
						end
					end	
				end	
			end
 
		if ( CheckCombatMode == false ) then
			EnterTeamCombatMode(Team.CIV_TEAM)
		end	
	
		end
		
		-- ochrona D7 Room 82
		if ( NPCInRoom( ProfileId,82 ) == true and gWorldSectorX == 7 and gWorldSectorY == SectorY.MAP_ROW_D and gWorldSectorZ == 0 )then 
		Legion2_SetTacticalStatusGroupAttack(SECTOR (7,SectorY.MAP_ROW_D) ,87,Status.CIV_GROUP_HOSTILE)
		
			for iLoop = GetTacticalStatusFirstID(Team.CIV_TEAM),GetTacticalStatusLastID(Team.CIV_TEAM) do
				if ( CheckMercPtrsInSector (iLoop) == true and CheckMercPtrsInActive(iLoop) == true and CheckMercPtrsInCivilianGroup (iLoop) == 87 ) then
					for aimLoop=GetTacticalStatusFirstID(Team.OUR_TEAM),GetTacticalStatusLastID(Team.OUR_TEAM) do
						if ( CheckMercPtrsID1SeenID2(iLoop,aimLoop) == SEEN_CURRENTLY ) then
						MakeMercPtrsHostile( iLoop )
						end
					end	
				end	
			end
 
		if ( CheckCombatMode == false ) then
			EnterTeamCombatMode(Team.CIV_TEAM)
		end	
	
		end
		
		-- Ochrona Sektor D7
		
		-- Godzina 6:05 lub 22:00
		if ( NPCInRoom( ProfileId,73 ) == true and gWorldSectorX == 7 and gWorldSectorY == SectorY.MAP_ROW_D and gWorldSectorZ == 0 )then 
		Legion2_SetTacticalStatusGroupAttack(SECTOR (7,SectorY.MAP_ROW_D) ,87,Status.CIV_GROUP_HOSTILE)
		
			for iLoop = GetTacticalStatusFirstID(Team.CIV_TEAM),GetTacticalStatusLastID(Team.CIV_TEAM) do
				if ( CheckMercPtrsInSector (iLoop) == true and CheckMercPtrsInActive(iLoop) == true and CheckMercPtrsInCivilianGroup (iLoop) == 87 ) then
					for aimLoop=GetTacticalStatusFirstID(Team.OUR_TEAM),GetTacticalStatusLastID(Team.OUR_TEAM) do
						if ( CheckMercPtrsID1SeenID2(iLoop,aimLoop) == SEEN_CURRENTLY ) then
						MakeMercPtrsHostile( iLoop )
						end
					end	
				end	
			end
 
		if ( CheckCombatMode == false ) then
			EnterTeamCombatMode(Team.CIV_TEAM)
		end	
	
		end
		
		Min = GetWorldMinutesInDay()
		-- Sektor D7. Godzina 6:05 lub 22:00
		if ( NPCInRoomRange( ProfileId,1, 239) == true and ( Min < 365 or Min > 1320 ) and gWorldSectorX == 7 and gWorldSectorY == SectorY.MAP_ROW_D and gWorldSectorZ == 0 )then 
		Legion2_SetTacticalStatusGroupAttack(SECTOR (7,SectorY.MAP_ROW_D) ,87,Status.CIV_GROUP_HOSTILE)
		
			for iLoop = GetTacticalStatusFirstID(Team.CIV_TEAM),GetTacticalStatusLastID(Team.CIV_TEAM) do
				if ( CheckMercPtrsInSector (iLoop) == true and CheckMercPtrsInActive(iLoop) == true and CheckMercPtrsInCivilianGroup (iLoop) == 87 ) then
					for aimLoop=GetTacticalStatusFirstID(Team.OUR_TEAM),GetTacticalStatusLastID(Team.OUR_TEAM) do
						if ( CheckMercPtrsID1SeenID2(iLoop,aimLoop) == SEEN_CURRENTLY ) then
						MakeMercPtrsHostile( iLoop )
						end
					end	
				end	
			end
 
		if ( CheckCombatMode == false ) then
			EnterTeamCombatMode(Team.CIV_TEAM)
		end	
	
		end
		
		
		-- sektor G12
		if ( NPCInRoom( ProfileId,40 ) == true and gWorldSectorX == 12 and gWorldSectorY == SectorY.MAP_ROW_G and gWorldSectorZ == 0 and CheckQuest (Quests.QUEST_SIERZANT) < pQuest.QUESTDONE )then 
			for iLoop = GetTacticalStatusFirstID(Team.CIV_TEAM),GetTacticalStatusLastID(Team.CIV_TEAM) do
				if ( CheckMercPtrsInSector (iLoop) == true and CheckMercPtrsInActive(iLoop) == true and CheckMercPtrsInCivilianGroup (iLoop) == Group.UNNAMED_CIV_GROUP_230 ) then
					for aimLoop=GetTacticalStatusFirstID(Team.OUR_TEAM),GetTacticalStatusLastID(Team.OUR_TEAM) do
						if ( CheckMercPtrsID1SeenID2(iLoop,aimLoop) == SEEN_CURRENTLY ) then
						MakeMercPtrsHostile( iLoop )
						end
					end	
				end	
			end
 
		if ( CheckCombatMode == false ) then
			EnterTeamCombatMode(Team.CIV_TEAM)
		end	
	
		end
		
		
		-- Sektor G12
		if ( gWorldSectorX == 12 and gWorldSectorY == SectorY.MAP_ROW_G and gWorldSectorZ == 0 and CheckQuest (Quests.QUEST_SIERZANT) < pQuest.QUESTDONE )then 
			if (PythSpacesAway( ProfileId, G12_Gridno_01 ) < 5) then
					
				for iLoop = GetTacticalStatusFirstID(Team.CIV_TEAM),GetTacticalStatusLastID(Team.CIV_TEAM) do
					if ( CheckMercPtrsInSector (iLoop) == true and CheckMercPtrsInActive(iLoop) == true and CheckMercPtrsInCivilianGroup (iLoop) == Group.UNNAMED_CIV_GROUP_230 ) then
						for aimLoop=GetTacticalStatusFirstID(Team.OUR_TEAM),GetTacticalStatusLastID(Team.OUR_TEAM) do
							if ( CheckMercPtrsID1SeenID2(iLoop,aimLoop) == SEEN_CURRENTLY ) then
							MakeMercPtrsHostile( iLoop )
							end
						end	
					end	
				end
 
				if ( CheckCombatMode == false ) then
					EnterTeamCombatMode(Team.CIV_TEAM)
				end	
			end
		end
		
		-- Sektor G12
		if ( NPCInRoom( ProfileId,42 ) == true and gWorldSectorX == 12 and gWorldSectorY == SectorY.MAP_ROW_G and gWorldSectorZ == 0 and CheckQuest (Quests.QUEST_SIERZANT) < pQuest.QUESTDONE )then 
		
		--SetCivGroupHostile( Group.UNNAMED_CIV_GROUP_230 , Status.CIV_GROUP_HOSTILE )
		
			for iLoop = GetTacticalStatusFirstID(Team.CIV_TEAM),GetTacticalStatusLastID(Team.CIV_TEAM) do
				if ( CheckMercPtrsInSector (iLoop) == true and CheckMercPtrsInActive(iLoop) == true and CheckMercPtrsInCivilianGroup (iLoop) == Group.UNNAMED_CIV_GROUP_230 ) then
					for aimLoop=GetTacticalStatusFirstID(Team.OUR_TEAM),GetTacticalStatusLastID(Team.OUR_TEAM) do
						if ( CheckMercPtrsID1SeenID2(iLoop,aimLoop) == SEEN_CURRENTLY ) then
						MakeMercPtrsHostile( iLoop )
						end
					end	
				end	
			end
 
		if ( CheckCombatMode == false ) then
			EnterTeamCombatMode(Team.CIV_TEAM)
		end	
	
		end
		
		
		-- Sektor J15
		if ( NPCInRoom( ProfileId,10 ) == true and gWorldSectorX == 15 and gWorldSectorY == SectorY.MAP_ROW_J and gWorldSectorZ == 0 )then 
		
			for iLoop = GetTacticalStatusFirstID(Team.CIV_TEAM),GetTacticalStatusLastID(Team.CIV_TEAM) do
				if ( CheckMercPtrsInSector (iLoop) == true and CheckMercPtrsInActive(iLoop) == true and CheckMercPtrsInCivilianGroup (iLoop) == Group.UNNAMED_CIV_GROUP_48 ) then
					for aimLoop=GetTacticalStatusFirstID(Team.OUR_TEAM),GetTacticalStatusLastID(Team.OUR_TEAM) do
						if ( CheckMercPtrsID1SeenID2(iLoop,aimLoop) == SEEN_CURRENTLY ) then
						MakeMercPtrsHostile( iLoop )
						end
					end	
				end	
			end
 
		if ( CheckCombatMode == false ) then
			EnterTeamCombatMode(Team.CIV_TEAM)
		end	
	
		end
		
		-- Sektor O10
		if ( NPCInRoom( ProfileId,7 ) == true and gWorldSectorX == 10 and gWorldSectorY == SectorY.MAP_ROW_O and gWorldSectorZ == 0 )then 
		
			for iLoop = GetTacticalStatusFirstID(Team.CIV_TEAM),GetTacticalStatusLastID(Team.CIV_TEAM) do
				if ( CheckMercPtrsInSector (iLoop) == true and CheckMercPtrsInActive(iLoop) == true and CheckMercPtrsInCivilianGroup (iLoop) == Group.UNNAMED_CIV_GROUP_48 ) then
					for aimLoop=GetTacticalStatusFirstID(Team.OUR_TEAM),GetTacticalStatusLastID(Team.OUR_TEAM) do
						if ( CheckMercPtrsID1SeenID2(iLoop,aimLoop) == SEEN_CURRENTLY ) then
						MakeMercPtrsHostile( iLoop )
						end
					end	
				end	
			end
 
		if ( CheckCombatMode == false ) then
			EnterTeamCombatMode(Team.CIV_TEAM)
		end	
	
		end
		
		-- Roboty
		if ( CheckGlobalBool(33) == true) then
			for iLoop = GetTacticalStatusFirstID(Team.CIV_TEAM),GetTacticalStatusLastID(Team.CIV_TEAM) do
				if ( CheckMercPtrsInSector (iLoop) == true and CheckMercPtrsInActive(iLoop) == true and CheckMercPtrsInCivilianGroup (iLoop) == Group.ROBOTY ) then
					for aimLoop=GetTacticalStatusFirstID(Team.OUR_TEAM),GetTacticalStatusLastID(Team.OUR_TEAM) do
						if ( CheckMercPtrsID1SeenID2(iLoop,aimLoop) == SEEN_CURRENTLY ) then
						MakeMercPtrsHostile( iLoop )
						end
					end	
				end	
			end
 
			if ( CheckCombatMode == false ) then
				EnterTeamCombatMode(Team.CIV_TEAM)
			end
		end
		
		-- K3
		if ( PythSpacesAway( ProfileId,K3_Gridno_01 ) < 5 and gWorldSectorX == 3 and gWorldSectorY == SectorY.MAP_ROW_K and gWorldSectorZ == 0 )then 	
			for Slot = 0, 54 do 
				Legion2_DelAllMercInventory (ProfileId,Slot,true)
			end
			DeadSoldier(ProfileId)
		end
		
		-- K3
		if ( PythSpacesAway( ProfileId,K3_Gridno_02 ) < 8 and gWorldSectorX == 3 and gWorldSectorY == SectorY.MAP_ROW_K and gWorldSectorZ == 0 )then 	
			for Slot = 0, 54 do 
				Legion2_DelAllMercInventory (ProfileId,Slot,true)
			end
			DeadSoldier(ProfileId)
		end
		
		-- M3
		if ( PythSpacesAway( ProfileId,M3_Gridno_01 ) < 6 and gWorldSectorX == 3 and gWorldSectorY == SectorY.MAP_ROW_M and gWorldSectorZ == 0 )then 	
			for Slot = 0, 54 do 
				Legion2_DelAllMercInventory (ProfileId,Slot,true)
			end
			DeadSoldier(ProfileId)
		end
		
		-- M3
		if ( PythSpacesAway( ProfileId,M3_Gridno_02 ) < 5 and gWorldSectorX == 3 and gWorldSectorY == SectorY.MAP_ROW_M and gWorldSectorZ == 0 )then 	
			for Slot = 0, 54 do 
				Legion2_DelAllMercInventory (ProfileId,Slot,true)
			end
			DeadSoldier(ProfileId)
		end
		
		-- M3
		if ( PythSpacesAway( ProfileId,M3_Gridno_03 ) < 5 and gWorldSectorX == 3 and gWorldSectorY == SectorY.MAP_ROW_M and gWorldSectorZ == 0 )then 	
			for Slot = 0, 54 do 
				Legion2_DelAllMercInventory (ProfileId,Slot,true)
			end
			DeadSoldier(ProfileId)
		end
		
		-- L3
		if ( PythSpacesAway( ProfileId,L3_Gridno_01 ) < 11 and gWorldSectorX == 3 and gWorldSectorY == SectorY.MAP_ROW_L and gWorldSectorZ == 0 )then 	
			for Slot = 0, 54 do 
				Legion2_DelAllMercInventory (ProfileId,Slot,true)
			end
			DeadSoldier(ProfileId)
		end
		
		-- L3
		if ( PythSpacesAway( ProfileId,L3_Gridno_02 ) < 11 and gWorldSectorX == 3 and gWorldSectorY == SectorY.MAP_ROW_L and gWorldSectorZ == 0 )then 	
			for Slot = 0, 54 do 
				Legion2_DelAllMercInventory (ProfileId,Slot,true)
			end
			DeadSoldier(ProfileId)
		end
		
		-- L3
		if ( PythSpacesAway( ProfileId,L3_Gridno_03 ) < 8 and gWorldSectorX == 3 and gWorldSectorY == SectorY.MAP_ROW_L and gWorldSectorZ == 0 )then 	
			for Slot = 0, 54 do 
				Legion2_DelAllMercInventory (ProfileId,Slot,true)
			end
			DeadSoldier(ProfileId)
		end
		
		-- L3
		if ( PythSpacesAway( ProfileId,L3_Gridno_04 ) < 8 and gWorldSectorX == 3 and gWorldSectorY == SectorY.MAP_ROW_L and gWorldSectorZ == 0 )then 	
			for Slot = 0, 54 do 
				Legion2_DelAllMercInventory (ProfileId,Slot,true)
			end
			DeadSoldier(ProfileId)
		end
	
	end
	
		if ( WhatKindOfMercAmI (ProfileId) == What.MERC_TYPE__EPC ) then -- what EPC
		
		
		--[[
			-- nieuzywane
			if ( CheckGlobalBool(25) == false and gWorldSectorX == 4 and gWorldSectorY == SectorY.MAP_ROW_P and gWorldSectorZ == 0 )then 

				if ( CheckGlobalBool(27) == false) then	
					-- Maria
					if ( NPCInRoom( 88, 3 ) == true ) then
						SetFactTrue(380) -- FACT_MARIA_SECTOR
						UnRecruitEPC( 88 )
						ChangeNpcToDifferentSector( 88, 4, SectorY.MAP_ROW_P, 0 ) 
					end
				elseif ( CheckGlobalBool(27) == true) then	
					UnRecruitEPC( 88 )
					TriggerNPCRecord( 88, 20 )
    				ChangeNpcToDifferentSector( 88, 4, SectorY.MAP_ROW_P, 0 ) 
					SetGlobalTrue(20)
				end
				
			end
			]]
			
			
			-- Legion 2
			
			-- Pacos
			if ( ProfileId == 114 and GetgubFact (373) == false and gWorldSectorX == 12 and gWorldSectorY == SectorY.MAP_ROW_G and gWorldSectorZ ==0 ) then
				if ( NPCInRoom( 114, 24 ) == true ) then
					ActionStopMerc( 114 )
					UnRecruitEPC( 114 )
					TriggerNPCRecord( 114, 20 )
					SetFactTrue( 373 ) -- FACT_PACOS_W_SEKTORZ_H13	
					EndQuest( 1, gWorldSectorX, gWorldSectorY )
				end
			end
			
			if ( ProfileId == 115 and PythSpacesAway( 115, Prof115_Gridn ) < 17 and gWorldSectorX == 1 and gWorldSectorY == SectorY.MAP_ROW_L and gWorldSectorZ ==0 and CheckQuest(35) == pQuest.QUESTINPROGRESS ) then
				
				TriggerNPCRecordImmediately(115,10)	
				ChangeNpcToDifferentSector( 115, 0, 0, 0 )	
				EndQuest( 35, gWorldSectorX, gWorldSectorY )
			
			end
		
		elseif ( TeamSoldier == Team.CIV_TEAM and ProfileId ~= NO_PROFILE and CheckSoldierNeutral( ProfileId ) == true ) then
	
			if ( ProfileId == Profil.JIM or ProfileId == Profil.JACK or ProfileId == Profil.OLAF or ProfileId == Profil.RAY or ProfileId == Profil.TYRONE ) then
	
				if ( not TileIsOutOfBounds( ClosestPC( ProfileId, sDesiredMercDist )) ) then 
					if ( sDesiredMercDist <= NPC_TALK_RADIUS * 2 ) then
						CancelAIAction ( ProfileId ) 
						AddToShouldBecomeHostileOrSayQuoteList( GetPlayerMercID(ProfileId) )
					end
				end
			end
		
		end -- End what EPC
		
  end -- End team
end